using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Threading;
using LFS_External.InSim;

namespace LFS_External_Client
{
    public partial class Form1 : Form
    {
        // InSim objects
        InSimInterface InSim;
        ConnectionSettings cfg;

        // These are the main lists that contain all Players and Connections (Being maintained automatically)
        List<clsConnection> Connections = new List<clsConnection>();
        List<clsPlayer> Players = new List<clsPlayer>();

        const string UserInfo = @"/users";

        System.Timers.Timer PayUser = new System.Timers.Timer(1000);

        public Form1()
        {
            InitializeComponent();
            InitializeInSimEvents(); // Event handlers (Uncoment a line in here to enable a packet receive event)
        }

		// Form load
		private void Form1_Load(object sender, EventArgs e)
		{
			try
			{
                PayUser.Enabled = true;
                PayUser.Elapsed += new System.Timers.ElapsedEventHandler(PayUser_Elapsed);
                if (System.IO.Directory.Exists(UserInfo) == false) System.IO.Directory.CreateDirectory(UserInfo);
				// Connect to InSim
                cfg = new ConnectionSettings("127.0.0.1", 29999, 0, Flags.InSimFlags.ISF_MCI, '!', 1000, "Password", "^3LFS External");
				InSim = new InSimInterface(cfg);
				InSim.Connect();

				// Leave this
				Thread.Sleep(500);

				// Request all players and connections
				InSim.Send_TINY(Enums.Tiny.TINY_NCN, 255);
				InSim.Send_TINY(Enums.Tiny.TINY_NPL, 255);
			}
			catch (Exception ex)
			{
				Debug.WriteLine(ex.Message);
                MessageBox.Show(string.Format(
                    "Could not connect to InSim: {0}", ex.Message), 
                    "InSim Error", 
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);
			}
		}

        private void PayUser_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
        {
            foreach (clsPlayer Ply in Players)
            {
                if (Ply.Payout > 4)
                {
                    Connections[GetConnIdx(Ply.UniqueID)].Cash += 2;
                    Ply.Payout = 0;
                    InSim.Send_BTN_CreateButton("^7" + Connections[GetConnIdx(Ply.UniqueID)].Cash, Flags.ButtonStyles.ISB_DARK, 5, 15, 0, 90, 5, Ply.UniqueID, 2, false);
                }
            }
        }

		// Close button
		private void btnClose_Click(object sender, EventArgs e)
		{
			InSim.Close();
			Application.Exit();
		}

        #region Default Methods
        // Uncomment a line in this method to enable its event.
        private void InitializeInSimEvents()
        {
            //LFS_External.InSim.Events.AXC_Received += new LFS_External.InSim.Events.AXC_EventHandler(AXC);
            //LFS_External.InSim.Events.AXI_Received += new LFS_External.InSim.Events.AXI_EventHandler(AXI);
            //LFS_External.InSim.Events.AXO_Received += new LFS_External.InSim.Events.AXO_EventHandler(AXO);
            //LFS_External.InSim.Events.BTC_Received += new LFS_External.InSim.Events.BTC_EventHandler(BTC);
            //LFS_External.InSim.Events.BTT_Received += new LFS_External.InSim.Events.BTT_EventHandler(BTT);
            //LFS_External.InSim.Events.BFN_Received += new LFS_External.InSim.Events.BFN_EventHandler(BFN);
            //LFS_External.InSim.Events.CCH_Received += new LFS_External.InSim.Events.CCH_EventHandler(CCH);
            //LFS_External.InSim.Events.CLR_Received += new LFS_External.InSim.Events.CLR_EventHandler(CLR);
            LFS_External.InSim.Events.CNL_Received += new LFS_External.InSim.Events.CNL_EventHandler(CNL);
            //LFS_External.InSim.Events.CPP_Received += new LFS_External.InSim.Events.CPP_EventHandler(CPP);
            LFS_External.InSim.Events.CPR_Received += new LFS_External.InSim.Events.CPR_EventHandler(CPR);
            //LFS_External.InSim.Events.CRS_Received += new LFS_External.InSim.Events.CRS_EventHandler(CRS);
            //LFS_External.InSim.Events.FIN_Received += new LFS_External.InSim.Events.FIN_EventHandler(FIN);
            //LFS_External.InSim.Events.FLG_Received += new LFS_External.InSim.Events.FLG_EventHandler(FLG);
            //LFS_External.InSim.Events.III_Received += new LFS_External.InSim.Events.III_EventHandler(III);
            //LFS_External.InSim.Events.ISM_Received += new LFS_External.InSim.Events.ISM_EventHandler(ISM);
            //LFS_External.InSim.Events.LAP_Received += new LFS_External.InSim.Events.LAP_EventHandler(LAP);
            LFS_External.InSim.Events.MCI_Received += new LFS_External.InSim.Events.MCI_EventHandler(MCI);
            //LFS_External.InSim.Events.MPE_Received += new LFS_External.InSim.Events.MPE_EventHandler(MPE);
            LFS_External.InSim.Events.MSO_Received += new LFS_External.InSim.Events.MSO_EventHandler(MSO);
            LFS_External.InSim.Events.NCN_Received += new LFS_External.InSim.Events.NCN_EventHandler(NCN);
            //LFS_External.InSim.Events.NLP_Received += new LFS_External.InSim.Events.NLP_EventHandler(NLP);
            LFS_External.InSim.Events.NPL_Received += new LFS_External.InSim.Events.NPL_EventHandler(NPL);
            //LFS_External.InSim.Events.PEN_Received += new LFS_External.InSim.Events.PEN_EventHandler(PEN);
            //LFS_External.InSim.Events.PFL_Received += new LFS_External.InSim.Events.PFL_EventHandler(PFL);
            //LFS_External.InSim.Events.PIT_Received += new LFS_External.InSim.Events.PIT_EventHandler(PIT);
            //LFS_External.InSim.Events.PLA_Received += new LFS_External.InSim.Events.PLA_EventHandler(PLA);
            LFS_External.InSim.Events.PLL_Received += new LFS_External.InSim.Events.PLL_EventHandler(PLL);
            //LFS_External.InSim.Events.PLP_Received += new LFS_External.InSim.Events.PLP_EventHandler(PLP);
            //LFS_External.InSim.Events.PSF_Received += new LFS_External.InSim.Events.PSF_EventHandler(PSF);
            //LFS_External.InSim.Events.REN_Received += new LFS_External.InSim.Events.REN_EventHandler(REN);
            //LFS_External.InSim.Events.REO_Received += new LFS_External.InSim.Events.REO_EventHandler(REO);
            //LFS_External.InSim.Events.REPLY_Received += new LFS_External.InSim.Events.REPLY_EventHandler(REPLY);
            //LFS_External.InSim.Events.RES_Received += new LFS_External.InSim.Events.RES_EventHandler(RES);
            //LFS_External.InSim.Events.RST_Received += new LFS_External.InSim.Events.RST_EventHandler(RST);
            //LFS_External.InSim.Events.RTP_Received += new LFS_External.InSim.Events.RTP_EventHandler(RTP);
            //LFS_External.InSim.Events.SPX_Received += new LFS_External.InSim.Events.SPX_EventHandler(SPX);
            //LFS_External.InSim.Events.STA_Received += new LFS_External.InSim.Events.STA_EventHandler(STA);
            LFS_External.InSim.Events.TOC_Received += new LFS_External.InSim.Events.TOC_EventHandler(TOC);
            //LFS_External.InSim.Events.VER_Received += new LFS_External.InSim.Events.VER_EventHandler(VER);
            //LFS_External.InSim.Events.VTA_Received += new LFS_External.InSim.Events.VTA_EventHandler(VTA);
            //LFS_External.InSim.Events.VTC_Received += new LFS_External.InSim.Events.VTC_EventHandler(VTC);
            //LFS_External.InSim.Events.VTN_Received += new LFS_External.InSim.Events.VTN_EventHandler(VTN);
        }

        // Methods for automatically update Players[] and Connection[] lists (Called from NPL and NCN)
        private void RemoveFromConnectionsList(Packets.IS_CNL CNL)
        {
            // Copy of item to remove
            clsConnection RemoveItem = new clsConnection();

            // Check what item the connection had
            foreach (clsConnection Conn in Connections)
            {
                if (CNL.UCID == Conn.UniqueID)
                {
                    // Copy item (Can't delete it here)
                    RemoveItem = Conn;
                    continue;
                }
            }

            // Remove item
            Connections.Remove(RemoveItem);
        }
        private void AddToConnectionsList(Packets.IS_NCN NCN)
        {
            bool InList = false;

            // Check of connection is already in the list
            foreach (clsConnection Conn in Connections)
            {
                if (Conn.UniqueID == NCN.UCID)
                {
                    InList = true;
                    continue;
                }
            }



            // If not, add it
            if (!InList)
            {
                // Assign values of new connnnection.
                clsConnection NewConn = new clsConnection();
                NewConn.UniqueID = NCN.UCID;
                NewConn.Username = NCN.UName;
                NewConn.PlayerName = NCN.PName;
                NewConn.IsAdmin = NCN.Admin;
                NewConn.Flags = NCN.Flags;
                NewConn.Cars = FileInfo.GetUserCars(NCN.UName);
                NewConn.Cash = FileInfo.GetUserCash(NCN.UName);

                Connections.Add(NewConn);
            }
        }
        private void RemoveFromPlayersList(Packets.IS_PLL PLL)
        {
            // Copy of item to remove
            clsPlayer RemoveItem = new clsPlayer();

            // Check what item the player had
            foreach (clsPlayer Player in Players)
            {
                if (PLL.PLID == Player.PlayerID)
                {
                    // Copy item (Can't delete it here)
                    RemoveItem = Player;
                    continue;
                }
            }

            // Remove item
            Players.Remove(RemoveItem);
        }
        private bool AddToPlayersList(Packets.IS_NPL NPL)
        {
            bool InList = false;

            // Check if player is already in the list
            foreach (clsPlayer Player in Players)
            {
                if (Player.PlayerID == NPL.PLID)
                {
                    Player.AddedMass = NPL.H_Mass;
                    Player.CarName = NPL.CName;
                    Player.Flags = NPL.Flags;
                    Player.Passengers = NPL.Pass;
                    Player.Plate = NPL.Plate;
                    Player.PlayerType = (clsPlayer.enuPType)NPL.PType;
                    Player.SkinName = NPL.SName;
                    Player.Tyre_FL = NPL.Tyre_FL;
                    Player.Tyre_FR = NPL.Tyre_FR;
                    Player.Tyre_RL = NPL.Tyre_RL;
                    Player.Tyre_RR = NPL.Tyre_RR;
					Player.IntakeRestriction = NPL.H_TRes;
                    return true;
                }
            }

            // If not, add it
            if (!InList)
            {
                // Assign values of new player.
                clsPlayer NewPLayer = new clsPlayer();
                NewPLayer.AddedMass = NPL.H_Mass;
                NewPLayer.CarName = NPL.CName;
                NewPLayer.Flags = NPL.Flags;
                NewPLayer.Passengers = NPL.Pass;
                NewPLayer.Plate = NPL.Plate;
                NewPLayer.PlayerID = NPL.PLID;
                NewPLayer.UniqueID = NPL.UCID;
                NewPLayer.PlayerName = NPL.PName;
                NewPLayer.PlayerType = (clsPlayer.enuPType)NPL.PType;
                NewPLayer.SkinName = NPL.SName;
                NewPLayer.Tyre_FL = NPL.Tyre_FL;
                NewPLayer.Tyre_FR = NPL.Tyre_FR;
                NewPLayer.Tyre_RL = NPL.Tyre_RL;
                NewPLayer.Tyre_RR = NPL.Tyre_RR;

                Players.Add(NewPLayer);
            }

            return false;
        }

        // Returns an index value for Connections[] that corresponds with the UniqueID of a connection
        public int GetConnIdx(int UNID)
        {
            for (int i = 0; i < Connections.Count; i++)
            {
                if (Connections[i].UniqueID == UNID) { return i; }
            }
            return 0;
        }

        // Returns an index value for Players[] that corresponds with the UniqueID of a player
        public int GetPlyIdx(int PLID)
        {
            for (int i = 0; i < Players.Count; i++)
            {
                if (Players[i].PlayerID == PLID) { return i; }
            }
            return 0;
        }
        #endregion

        /**********************************/
        /********* PACKET ARRIVAL *********/			// (Uncomment an event in the InitializeInSimEvents method and create the corresponding method down here to enable an other event)
        /**********************************/
        private void NPL(Packets.IS_NPL NPL)
        {
            if (Connections[GetConnIdx(NPL.UCID)].Cars.Contains(NPL.CName) != true){
                InSim.Send_MST_Message("/spec " + Connections[GetConnIdx(NPL.UCID)].Username);
                InSim.Send_MST_Message("/msg " + Connections[GetConnIdx(NPL.UCID)].PlayerName + " ^7tried to steal " + NPL.CName);}

            bool LeavesPits = AddToPlayersList(NPL);    // Update Players[] list (don't remove this line!)
        }

        private void NCN(Packets.IS_NCN NCN)
        {
            FileInfo.NewUser(NCN.UName);

            AddToConnectionsList(NCN);                  // Update Connections[] list (don't remove this line!)

            InSim.Send_BTN_CreateButton("^7" + Connections[GetConnIdx(NCN.UCID)].Cash, Flags.ButtonStyles.ISB_DARK, 5, 15, 0, 90, 5, NCN.UCID, 2, false);
        }

        private void CNL(Packets.IS_CNL CNL)
        {
            FileInfo.UpdateUserLeave(Connections[GetConnIdx(CNL.UCID)].Username, Connections[GetConnIdx(CNL.UCID)].Cash, Connections[GetConnIdx(CNL.UCID)].Cars);
 
            RemoveFromConnectionsList(CNL);             // Update Connections[] list (don't remove this line!)
        }

        private void CPR(Packets.IS_CPR CPR)
        {
			foreach (clsConnection c in Connections)    // Update Connections[] and Players[] list (Don't remove those 2 foreach loops!)
				if (c.UniqueID == CPR.UCID)
				{
					c.PlayerName = CPR.PName;
				}

			foreach (clsPlayer p in Players)
				if (p.UniqueID == CPR.UCID)
				{
					p.PlayerName = CPR.PName;
					p.Plate = CPR.Plate;
				}
        }

        private void MSO(Packets.IS_MSO MSO)
        {
            string Msg = MSO.Msg.Substring(MSO.TextStart, (MSO.Msg.Length - MSO.TextStart));
            string[] StrMsg = Msg.Split(' ');

            switch (StrMsg[0])
            {
                case "!help":
                    InSim.Send_MTC_MessageToConnection("^7Help menu!", MSO.UCID, 0);
                    break;

                case "!cash":
                    InSim.Send_MTC_MessageToConnection("^7Cash: " + Connections[GetConnIdx(MSO.UCID)].Cash, MSO.UCID, 0);
                    break;

                case "!cars":
                    InSim.Send_MTC_MessageToConnection("^7Cars: " + Connections[GetConnIdx(MSO.UCID)].Cars, MSO.UCID, 0);
                    break;

                case "!pay":
                    if (StrMsg.Length > 0)
                    {
                        if (StrMsg[1].Contains("-"))
                            InSim.Send_MTC_MessageToConnection("^7Invalid command", MSO.UCID, 0);
                        else
                        {
                            int Pay = int.Parse(StrMsg[1]);
                            Connections[GetConnIdx(MSO.UCID)].Cash -= Pay;
                            InSim.Send_MST_Message("/msg " + Connections[GetConnIdx(MSO.UCID)].PlayerName + "^7 paid " + Pay + " fine");
                        }
                    }
                    break;

                case "!buy":
                    if (StrMsg.Length > 1)
                    {
                        if (Connections[GetConnIdx(MSO.UCID)].Cars.Contains(StrMsg[1].ToUpper()))
                            InSim.Send_MTC_MessageToConnection("^7Car already owned", MSO.UCID, 0);
                        else if (Dealer.GetCarPrice(StrMsg[1]) == 0)
                            InSim.Send_MTC_MessageToConnection("^7Invalid car selection", MSO.UCID, 0);
                        else if (Connections[GetConnIdx(MSO.UCID)].Cash >= Dealer.GetCarPrice(StrMsg[1]))
                        {
                            string Cars = Connections[GetConnIdx(MSO.UCID)].Cars;

                            switch (StrMsg[1].ToUpper())
                            {
                                case "UF1":
                                    Cars = Cars + " " + "UF1";
                                    Connections[GetConnIdx(MSO.UCID)].Cars = Cars;
                                    Connections[GetConnIdx(MSO.UCID)].Cash -= Dealer.GetCarPrice("UF1");
                                    InSim.Send_MST_Message("/msg " + Connections[GetConnIdx(MSO.UCID)].PlayerName + " ^7bought a UF1");
                                    break;

                                case "XFG":
                                    Cars = Cars + " " + "XFG";
                                    Connections[GetConnIdx(MSO.UCID)].Cars = Cars;
                                    Connections[GetConnIdx(MSO.UCID)].Cash -= Dealer.GetCarPrice("XFG");
                                    InSim.Send_MST_Message("/msg " + Connections[GetConnIdx(MSO.UCID)].PlayerName + " ^7bought a XFG");
                                    break;

                                case "XRG":
                                    Cars = Cars + " " + "XRG";
                                    Connections[GetConnIdx(MSO.UCID)].Cars = Cars;
                                    Connections[GetConnIdx(MSO.UCID)].Cash -= Dealer.GetCarPrice("XRG");
                                    InSim.Send_MST_Message("/msg " + Connections[GetConnIdx(MSO.UCID)].PlayerName + " ^7bought a XRG");
                                    break;

                                case "LX4":
                                    Cars = Cars + " " + "LX4";
                                    Connections[GetConnIdx(MSO.UCID)].Cars = Cars;
                                    Connections[GetConnIdx(MSO.UCID)].Cash -= Dealer.GetCarPrice("LX4");
                                    InSim.Send_MST_Message("/msg " + Connections[GetConnIdx(MSO.UCID)].PlayerName + " ^7bought a LX4");
                                    break;

                                case "LX6":
                                    Cars = Cars + " " + "LX6";
                                    Connections[GetConnIdx(MSO.UCID)].Cars = Cars;
                                    Connections[GetConnIdx(MSO.UCID)].Cash -= Dealer.GetCarPrice("LX6");
                                    InSim.Send_MST_Message("/msg " + Connections[GetConnIdx(MSO.UCID)].PlayerName + " ^7bought a LX6");
                                    break;

                                case "RB4":
                                    Cars = Cars + " " + "RB4";
                                    Connections[GetConnIdx(MSO.UCID)].Cars = Cars;
                                    Connections[GetConnIdx(MSO.UCID)].Cash -= Dealer.GetCarPrice("RB4");
                                    InSim.Send_MST_Message("/msg " + Connections[GetConnIdx(MSO.UCID)].PlayerName + " ^7bought a RB4");
                                    break;

                                case "FXO":
                                    Cars = Cars + " " + "FXO";
                                    Connections[GetConnIdx(MSO.UCID)].Cars = Cars;
                                    Connections[GetConnIdx(MSO.UCID)].Cash -= Dealer.GetCarPrice("FXO");
                                    InSim.Send_MST_Message("/msg " + Connections[GetConnIdx(MSO.UCID)].PlayerName + " ^7bought a FXO");
                                    break;

                                case "XRT":
                                    Cars = Cars + " " + "XRT";
                                    Connections[GetConnIdx(MSO.UCID)].Cars = Cars;
                                    Connections[GetConnIdx(MSO.UCID)].Cash -= Dealer.GetCarPrice("XRT");
                                    InSim.Send_MST_Message("/msg " + Connections[GetConnIdx(MSO.UCID)].PlayerName + " ^7bought a XRT");
                                    break;

                                case "RAC":
                                    Cars = Cars + " " + "RAC";
                                    Connections[GetConnIdx(MSO.UCID)].Cars = Cars;
                                    Connections[GetConnIdx(MSO.UCID)].Cash -= Dealer.GetCarPrice("RAC");
                                    InSim.Send_MST_Message("/msg " + Connections[GetConnIdx(MSO.UCID)].PlayerName + " ^7bought a RAC");
                                    break;

                                case "FZ5":
                                    Cars = Cars + " " + "FZ5";
                                    Connections[GetConnIdx(MSO.UCID)].Cars = Cars;
                                    Connections[GetConnIdx(MSO.UCID)].Cash -= Dealer.GetCarPrice("FZ5");
                                    InSim.Send_MST_Message("/msg " + Connections[GetConnIdx(MSO.UCID)].PlayerName + " ^7bought a FZ5");
                                    break;

                                case "UFR":
                                    Cars = Cars + " " + "UFR";
                                    Connections[GetConnIdx(MSO.UCID)].Cars = Cars;
                                    Connections[GetConnIdx(MSO.UCID)].Cash -= Dealer.GetCarPrice("UFR");
                                    InSim.Send_MST_Message("/msg " + Connections[GetConnIdx(MSO.UCID)].PlayerName + " ^7bought a UFR");
                                    break;

                                case "XFR":
                                    Cars = Cars + " " + "XFR";
                                    Connections[GetConnIdx(MSO.UCID)].Cars = Cars;
                                    Connections[GetConnIdx(MSO.UCID)].Cash -= Dealer.GetCarPrice("XFR");
                                    InSim.Send_MST_Message("/msg " + Connections[GetConnIdx(MSO.UCID)].PlayerName + " ^7bought a XFR");
                                    break;

                                case "FXR":
                                    Cars = Cars + " " + "FXR";
                                    Connections[GetConnIdx(MSO.UCID)].Cars = Cars;
                                    Connections[GetConnIdx(MSO.UCID)].Cash -= Dealer.GetCarPrice("FXR");
                                    InSim.Send_MST_Message("/msg " + Connections[GetConnIdx(MSO.UCID)].PlayerName + " ^7bought a FXR");
                                    break;

                                case "XRR":
                                    Cars = Cars + " " + "XRR";
                                    Connections[GetConnIdx(MSO.UCID)].Cars = Cars;
                                    Connections[GetConnIdx(MSO.UCID)].Cash -= Dealer.GetCarPrice("XRR");
                                    InSim.Send_MST_Message("/msg " + Connections[GetConnIdx(MSO.UCID)].PlayerName + " ^7bought a XRR");
                                    break;

                                case "FZR":
                                    Cars = Cars + " " + "FZR";
                                    Connections[GetConnIdx(MSO.UCID)].Cars = Cars;
                                    Connections[GetConnIdx(MSO.UCID)].Cash -= Dealer.GetCarPrice("FZR");
                                    InSim.Send_MST_Message("/msg " + Connections[GetConnIdx(MSO.UCID)].PlayerName + " ^7bought a FZR");
                                    break;
                            }
                        }
                        else InSim.Send_MTC_MessageToConnection("^7Not enough cash", MSO.UCID, 0);
                    }
                    else InSim.Send_MTC_MessageToConnection("^7Command error", MSO.UCID, 0);
                    break;


                case "!sell":
                    if (StrMsg.Length > 1)
                    {
                        if (Connections[GetConnIdx(MSO.UCID)].Cars.Contains(StrMsg[1].ToUpper()))
                        {
                            if (Dealer.GetCarPrice(StrMsg[1].ToUpper()) > 0)
                            {
                                string UserCars = Connections[GetConnIdx(MSO.UCID)].Cars.Trim();
                                int IdxCar = UserCars.IndexOf(StrMsg[1].ToUpper().Trim());
                                //string UserCars = Connections[GetConnIdx(MSO.UCID)].Cars;
                                try { Connections[GetConnIdx(MSO.UCID)].Cars = UserCars.Remove(IdxCar, 4); }
                                catch { Connections[GetConnIdx(MSO.UCID)].Cars = UserCars.Remove(IdxCar, 3); }
                                Connections[GetConnIdx(MSO.UCID)].Cash += Dealer.GetCarValue(StrMsg[1].ToUpper());
                                InSim.Send_MST_Message("/msg " + Connections[GetConnIdx(MSO.UCID)].PlayerName + " sold " + StrMsg[1].ToUpper());

                            }
                            else InSim.Send_MTC_MessageToConnection("^7Car does not exist!", MSO.UCID, 0);
                        }
                        else InSim.Send_MTC_MessageToConnection("^7You do not own that car!", MSO.UCID, 0);
                    }
                    else InSim.Send_MTC_MessageToConnection("^7Command error!", MSO.UCID, 0);
                    break;

                case "!send":
                    {
                        // Get the connection of the person sending the cash.
                        clsConnection fromConnection = Connections[GetConnIdx(MSO.UCID)];

                        // Uncomment to allow only admins to send cash.
                        //if (fromConnection.IsAdmin != 1)
                        //{
                        //    InSim.Send_MTC_MessageToConnection(
                        //        "^7Only an admin can send cash.",
                        //        MSO.UCID,
                        //        0);
                        //    return;
                        //}

                        // Parse the amount of cash to send.
                        int cash = 0;
                        if (StrMsg.Length < 2)
                        {
                            InSim.Send_MTC_MessageToConnection(
                                "^7You must enter an amount and a username.",
                                MSO.UCID,
                                0);
                            return;
                        }
                        if (!int.TryParse(StrMsg[1], out cash))
                        {
                            InSim.Send_MTC_MessageToConnection(
                                string.Format("^7'{0}' is not a valid amount of cash.", StrMsg[1]),
                                MSO.UCID,
                                0);
                            return;
                        }

                        // Get the username for the person to send it to.
                        string toUser = string.Empty;
                        if (StrMsg.Length > 2)
                            for (int i = 2; i < StrMsg.Length; i++)
                                toUser += string.Format("{0} ", StrMsg[i]);
                        else
                        {
                            InSim.Send_MTC_MessageToConnection(
                                "^7You must enter a username.",
                                MSO.UCID,
                                0);
                            return;
                        }

                        // Get the connection we're sending the cash to.
                        clsConnection toConnection = null;
                        foreach (clsConnection c in Connections)
                            if (c.Username.ToLower() == toUser.Trim().ToLower())
                                toConnection = c;

                        // Update their amount of cash, update their button and send the host message.
                        if (toConnection == null)
                        {
                            InSim.Send_MTC_MessageToConnection(
                                string.Format("^7No player with the username '{0}' exists.", toUser),
                                MSO.UCID,
                                0);
                            return;
                        }

                        toConnection.Cash += cash;
                        fromConnection.Cash -= cash;
                        InSim.Send_MST_Message(string.Format(
                            "^7{0} sent money to {1}!",
                            Connections[GetConnIdx(MSO.UCID)].Username,
                            toUser));
                        InSim.Send_BTN_CreateButton(
                            "^7" + toConnection.Cash,
                            Flags.ButtonStyles.ISB_DARK,
                            5,
                            15,
                            0,
                            90,
                            5,
                            toConnection.UniqueID,
                            2,
                            false);
                    }
                    break;
            }
        }

        private void PLL(Packets.IS_PLL PLL)
        {
            RemoveFromPlayersList(PLL);                 // Update Players[] list (don't remove this line!)
        }

        private void TOC(Packets.IS_TOC TOC)
        {
            Players[GetPlyIdx(TOC.PLID)].UniqueID = TOC.NewUCID;		// Update Players[] list (don't remove this line!)
            Players[GetPlyIdx(TOC.PLID)].PlayerName = Connections[GetConnIdx(TOC.NewUCID)].PlayerName;		// Update Players[] list (don't remove this line!)
        }

        private void MCI(Packets.IS_MCI MCI)
        {
            for (int i = 0; i < Players.Count; i++)
            {
                decimal Speed = (decimal)((MCI.Info[i].Speed * (100f / 32768f)) * 3.6f);
                decimal ConvSpeed = (decimal)(Speed * 25 / 1000);
                Players[GetPlyIdx(MCI.Info[i].PLID)].Payout += ConvSpeed;
            }
        }
    }
}